#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
using namespace std;

#define ios ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
#define ll long long
#define ull unsigned long long
#define inf 1e15
#define llinf LLONG_MAX
#define mt make_tuple
#define mp make_pair
#define parll pair<ll,ll>
#define parii pair<int,int>
#define frs first
#define sec second
#define neparno(x) (x&1)
#define parno(x) (!neparno(x))
#define lowbit(x) (x&-x)
#define nzd __gcd
#define nzs(e1,e2) ((e1*e2)/nzd(e1,e2))
#define yesno(x) cout << ((x)?"Yes\n":"No\n")
#define condcout(x,y,z) cout << ((x)?y:z) << "\n"
#define all(V) V.begin(),V.end()
#define fill(V,v) fill(all(V),v)
#define l_b(BRL,brl) lower_bound( BRL.begin(), BRL.end(), brl )-BRL.begin()-1
#define u_b(BRU,bru) upper_bound( BRU.begin(), BRU.end(), bru )-BRU.begin()
#define mod 1000000007
#define mxn 100005

struct Point
{
    ll x, y;
    bool operator<(const Point &other) const {
        return (y < other.y || (y == other.y && x < other.x));
    }
    bool operator==(const Point &other) const {
        return (x == other.x && y == other.y);
    }
};

ll CrossProduct( Point p1, Point p2, Point p3 )
{
    return (p2.x-p1.x)*(p3.y-p1.y)-(p2.y-p1.y)*(p3.x-p1.x);
}

ll Cross( const Point &a, const Point &b )
{
    return a.x*b.y-a.y*b.x;
}

ll CalculateArea( const vector<Point> &hull )
{
    if ( hull.size() < 3 )
    {
        return 0;
    }

    ll area=0,n=hull.size();
    for ( ll i = 0; i < n; i++ )
    {
        const Point &current = hull[i];
        const Point &next = hull[(i+1)%n];
        area += Cross(current,next);
    }
    return abs(area);
}

Point pivot;

bool cmp( const Point &a, const Point &b )
{
    ll cross = CrossProduct(pivot,a,b);
    if ( cross == 0 )
    {
        ll d1 = (a.x-pivot.x)*(a.x-pivot.x)+(a.y-pivot.y)*(a.y-pivot.y);
        ll d2 = (b.x-pivot.x)*(b.x-pivot.x)+(b.y-pivot.y)*(b.y-pivot.y);
        return (d1<d2);
    }
    return (cross>0);
}

vector <ll> ids;

vector <Point> ComputeConvexHull( vector<Point> &points, bool trackIds = true )
{
    ll n = points.size();
    if ( n <= 3 )
    {
        return points;
    }

    ll bottom = 0;
    for ( ll i = 1; i < n; i++ )
    {
        if ( points[i] < points[bottom] )
        {
            bottom = i;
        }
    }

    swap( points[0], points[bottom] );
    pivot = points[0];

    sort(points.begin()+1,points.end(),cmp);

    vector <Point> hull;
    hull.push_back(points[0]);
    hull.push_back(points[1]);
    if ( trackIds )
    {
        ids.push_back(0);
        ids.push_back(1);
    }
    for ( ll i = 2; i < n; i++ )
    {
        while ( hull.size() >= 2 && CrossProduct(hull[hull.size()-2],hull.back(),points[i]) <= 0 )
        {
            hull.pop_back();
            if ( trackIds )
            {
                ids.pop_back();
            }
        }
        hull.push_back(points[i]);
        if ( trackIds )
        {
            ids.push_back(i);
        }
    }
    return hull;
}

ll n;

int main()
{
    ios;

    cin >> n;
    vector <Point> points(n);
    for ( ll i = 0; i < n; i++ )
    {
        cin >> points[i].x >> points[i].y;
    }

    ll uk,rez;
    vector <Point> hull = ComputeConvexHull(points);
    uk = rez = CalculateArea(hull);

    vector <Point> T = points;

    T.erase(find(all(T),hull[0]));
    T = ComputeConvexHull(T,false);
    rez = min( rez, (ll)CalculateArea(T) );

    T = points;
    T.erase(find(all(T),hull.back()));
    T = ComputeConvexHull(T,false);
    rez = min( rez, (ll)CalculateArea(T) );

    T = points;
    T.erase(find(all(T),hull[1]));
    T = ComputeConvexHull(T, false);
    rez = min( rez, (ll)CalculateArea(T) );

    for ( ll k = 3; k < (ll)ids.size(); k++ )
    {
        vector <Point> NewHull;
        NewHull.push_back(hull[k-2]);

        ll extraArea = Cross(hull[k-2],hull[k-1])+Cross(hull[k-1],hull[k]);
        ll currentArea = uk-extraArea;
        for ( ll i = ids[k-2]+1; i <= ids[k]; i++ )
        {
            if ( i == ids[k-1] )
            {
                continue;
            }
            while ( NewHull.size() >= 2 && CrossProduct(NewHull[NewHull.size()-2],NewHull.back(),points[i]) <= 0 )
            {
                NewHull.pop_back();
            }
            NewHull.push_back(points[i]);
        }

        for ( ll i = 0; i < (ll)NewHull.size()-1; i++ )
        {
            currentArea += Cross(NewHull[i],NewHull[i+1]);
        }
        rez = min( rez, abs(currentArea) );
    }
    cout << (rez/2) << "\n";

    return 0;
}